// Numeric Move
//
// @author Hiroto Tsubaki (tg_jp) tg@tres-graficos.jp
//
// Tool script ( ~/Library/Application Support/Cheetah3D/scripts/Tool to install )
//

function buildUI( tool ) {
    
    tool.addParameterSelector("coordinate system", ["object", "world"], false, true);
    tool.addParameterFloat("x", 0, -10000, 10000, false, true);
    tool.addParameterFloat("y", 0, -10000, 10000, false, true);
    tool.addParameterFloat("z", 0, -10000, 10000, false, true);
    
    tool.addParameterButton("move", "move", "moveSelection");
    
    tool.addParameterSeparator("re-get");
    tool.addParameterButton("get", "get", "getPositionForSelection");
    
    getPositionForSelection( tool );
}

function getPositionForSelection( tool ) {
    
    var vec = getCenterVec( tool );
    
    print( vec.x + ',' + vec.y + ', ' + vec.z );
    
    tool.setParameter("x", vec.x );
    tool.setParameter("y", vec.y );
    tool.setParameter("z", vec.z );
}

function moveSelection( tool ) {
    
    var doc = tool.document();
    var obj = doc.selectedObject();
    
    if (obj.type() != POLYGONOBJ) return;
    
    var cs = tool.getParameter("coordinate system");
    if (cs == 1) {
        var mat = obj.objMatrix().inverse();
    } else {
        var mat = new Mat4D();
    }
    
    var x = tool.getParameter("x");
    var y = tool.getParameter("y");
    var z = tool.getParameter("z");
    
    var core = obj.core();
    var vec = mat.multiply( new Vec3D(x, y, z) );
    var center_vec = mat.multiply( getCenterVec( tool ) );
    
    var mode = doc.editMode();
    
    switch( mode ) {
        case POINT_MODE:
            var vertexCount = core.vertexCount();
            for (var i = 0;i < vertexCount;i++) {
                if (core.vertexSelection(i)) {
                    //core.setVertex(i, vec.add( center_vec.sub(core.vertex(i))) );
                    core.setVertex(i, vec.add( core.vertex(i).sub( center_vec ) ) );
                }
            }
            break;
        case EDGE_MODE:
            var moved = [];
            var polygonCount = core.polygonCount();
            for (var i = 0;i < polygonCount;i++) {
                var polygonSize = core.polygonSize( i );
                for (var j = 0;j < polygonSize;j++) {
                    if (core.edgeSelection(i, j, SELECT)) {
                        var i1 = core.vertexIndex(i, j);
                        var i2 = (j==polygonSize-1)? core.vertexIndex(i, 0) : core.vertexIndex(i, j+1);
                        if (moved.indexOf(i1) < 0) {
                            core.setVertex( i1,
                                    vec.add( core.vertex( i1 ).sub( center_vec ) ) );
                            moved.push( i1 );
                        }
                        if (moved.indexOf(i2) < 0) {
                            core.setVertex( i2,
                                    vec.add( core.vertex( i2 ).sub( center_vec ) ) );
                            moved.push( i2 );
                        }
                    }
                }
            }
            break;
        case POLY_MODE:
            var moved = [];
            var polygonCount = core.polygonCount();
            for (var i = 0;i < polygonCount;i++) {
                if (core.polygonSelection( i ) ) {
                    var polygonSize = core.polygonSize( i );
                    for( var j = 0;j < polygonSize;j++) {
                        var i1 = core.vertexIndex(i, j);
                        if (moved.indexOf(i1) < 0) {
                            core.setVertex( core.vertexIndex(i, j),
                                    vec.add( core.vertex( i1 ).sub( center_vec ) ) );
                            moved.push( i1 );
                        }
                    }
                }
            }
            break;
    }
    
    obj.update();
}

function printVec3D( vec ) {
	print( vec.x.toFixed(6) + ' ' + vec.y.toFixed(6) + ' ' + vec.z.toFixed(6) );
}

function getCenterVec( tool ) {
    var doc = tool.document();
    var obj = doc.selectedObject();
    
    if (obj.type() != POLYGONOBJ) return new Vec3D();
    
    var cs = tool.getParameter("coordinate system");
    if (cs == 1) {
        var mat = obj.objMatrix();
    } else {
        var mat = new Mat4D();
    }
    
    var core = obj.core();
    var vec = new Vec3D();
    
    var mode = doc.editMode();
    
    switch( mode ) {
        case POINT_MODE:
            var vertexCount = core.vertexCount();
            var selCount = 0;
            for (var i = 0;i < vertexCount;i++) {
                if (core.vertexSelection(i)) {
                    vec = vec.add( core.vertex(i) );
                    selCount++;
                }
            }
            if ( selCount > 0 ) vec = vec.multiply( 1 / selCount );
            break;
        case EDGE_MODE:
            var polygonCount = core.polygonCount();
            var selCount = 0;
            for (var i = 0;i < polygonCount;i++) {
                var polygonSize = core.polygonSize( i );
                for ( var j = 0;j < polygonSize;j++) {
                    if (core.edgeSelection(i, j, SELECT)) {
                        vec = vec.add( core.vertex( core.vertexIndex( i, j ) ).multiply( 1/2 ) );
                        if (j == polygonSize-1) {
                            vec = vec.add( core.vertex( core.vertexIndex( i, 0 ) ).multiply( 1/2 ) );
                        } else {
                            vec = vec.add( core.vertex( core.vertexIndex( i, j+1) ).multiply( 1/2 ) );
                        }
                        selCount++;
                    }
                }
            }
            if (selCount > 0) vec = vec.multiply( 1 / selCount );
            break;
        case POLY_MODE:
            var polygonCount = core.polygonCount();
            var selCount = 0;
            for (var i = 0;i < polygonCount;i++) {
                if (core.polygonSelection( i ) ) {
                    var polygonSize = core.polygonSize( i );
                    for( var j = 0;j < polygonSize;j++) {
                        vec = vec.add( core.vertex( core.vertexIndex( i, j ) ).multiply( 1/polygonSize ) );
                    }
                    selCount++;
                }
            }
            if (selCount > 0) vec = vec.multiply( 1 / selCount );
            break;
    }
    
    return mat.multiply(vec);
}